-- phpMyAdmin SQL Dump
-- version 5.1.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Sep 19, 2023 at 04:21 AM
-- Server version: 8.0.27
-- PHP Version: 7.4.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `unis`
--
CREATE DATABASE IF NOT EXISTS `unis` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
USE `unis`;

-- --------------------------------------------------------

--
-- Table structure for table `AcademicTerm`
--

DROP TABLE IF EXISTS `AcademicTerm`;
CREATE TABLE IF NOT EXISTS `AcademicTerm` (
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `Term` varchar(50) NOT NULL,
  `AdmissionYear` year NOT NULL,
  PRIMARY KEY (`AcademicTermID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `AcademicTerm`
--

INSERT INTO `AcademicTerm` (`AcademicTermID`, `Term`, `AdmissionYear`) VALUES
(0000000001, '1st Semester', 2024),
(0000000002, '2nd Semester', 2024),
(0000000003, 'Midyear', 2024);

-- --------------------------------------------------------

--
-- Table structure for table `accountlogs`
--

DROP TABLE IF EXISTS `accountlogs`;
CREATE TABLE IF NOT EXISTS `accountlogs` (
  `AccountLogsID` bigint NOT NULL,
  `EmailAddress` varchar(200) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `Remarks` varchar(300) DEFAULT NULL,
  `Action` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`AccountLogsID`),
  KEY `fk_AccountLogs_GoogleAccount1_idx` (`EmailAddress`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `activityvenue`
--

DROP TABLE IF EXISTS `activityvenue`;
CREATE TABLE IF NOT EXISTS `activityvenue` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`OrgActivityID`,`VenueID`),
  KEY `fk_ActivityVenue_OrgActiviy1_idx` (`OrgActivityID`),
  KEY `fk_ActivityVenue_Venue1_idx` (`VenueID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `admissionaccount`
--

DROP TABLE IF EXISTS `admissionaccount`;
CREATE TABLE IF NOT EXISTS `admissionaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  PRIMARY KEY (`EmailAddress`),
  KEY `fk_AdmissionAccount_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `assessmentfeessettings`
--

DROP TABLE IF EXISTS `assessmentfeessettings`;
CREATE TABLE IF NOT EXISTS `assessmentfeessettings` (
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentCode` varchar(45) NOT NULL,
  `AssessmentSchoolYear` varchar(45) NOT NULL,
  `AssessmentType` varchar(200) NOT NULL,
  `AssessmentDescription` varchar(200) NOT NULL,
  `AssessmentAmount` float(15,2) NOT NULL,
  `AssessmentStatus` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`AssessmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `campus`
--

DROP TABLE IF EXISTS `campus`;
CREATE TABLE IF NOT EXISTS `campus` (
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CampusName` varchar(300) NOT NULL,
  `CampusAddress` varchar(500) NOT NULL,
  PRIMARY KEY (`CampusID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `campus`
--

INSERT INTO `campus` (`CampusID`, `CampusName`, `CampusAddress`) VALUES
(0000000001, 'CSPC Main', 'Nabua, Cam Sur'),
(0000000002, 'CSPC Bula', 'Bula, Cam Sur');

-- --------------------------------------------------------

--
-- Table structure for table `citizenship`
--

DROP TABLE IF EXISTS `citizenship`;
CREATE TABLE IF NOT EXISTS `citizenship` (
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `Citizenship` varchar(250) NOT NULL,
  PRIMARY KEY (`CitizenshipID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `classtype`
--

DROP TABLE IF EXISTS `classtype`;
CREATE TABLE IF NOT EXISTS `classtype` (
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `ClassType` varchar(45) NOT NULL COMMENT 'Lab, Lec, Workshop',
  PRIMARY KEY (`ClassTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `clearance`
--

DROP TABLE IF EXISTS `clearance`;
CREATE TABLE IF NOT EXISTS `clearance` (
  `ClearanceID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `DeansIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `OSASIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `StudentCouncilIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `CashierIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `RegistrarIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AccountingIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `PTAIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AlumniIsVerify` varchar(100) NOT NULL,
  PRIMARY KEY (`ClearanceID`),
  KEY `fk_Clearance_Student_Assessment1_idx` (`AssessmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `college`
--

DROP TABLE IF EXISTS `college`;
CREATE TABLE IF NOT EXISTS `college` (
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CollegeDesc` varchar(450) NOT NULL,
  `CollegeAbbr` varchar(200) NOT NULL,
  PRIMARY KEY (`CollegeID`),
  KEY `fk_College_Campus_idx` (`CampusID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `college`
--

INSERT INTO `college` (`CollegeID`, `CampusID`, `CollegeDesc`, `CollegeAbbr`) VALUES
(0000000001, 0000000001, 'College of Computer Studies', 'CCS'),
(0000000002, 0000000001, 'College of Engineering and Architecture', 'CEA');

-- --------------------------------------------------------

--
-- Table structure for table `course`
--

DROP TABLE IF EXISTS `course`;
CREATE TABLE IF NOT EXISTS `course` (
  `CourseCode` varchar(30) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseName` varchar(300) NOT NULL,
  PRIMARY KEY (`CourseCode`),
  KEY `fk_Course_Program1_idx` (`ProgramID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `course`
--

INSERT INTO `course` (`CourseCode`, `ProgramID`, `CourseName`) VALUES
('CCCS 101', 0000000002, 'Artificial Intelligence'),
('CCCS 102', 0000000002, 'Computer Programming'),
('CCCS 103', 0000000002, 'Database Design'),
('CCIT101', 0000000001, 'Introduction to Computing'),
('CCIT102', 0000000001, 'Web Development'),
('CCIT103', 0000000001, 'Database Design');

-- --------------------------------------------------------

--
-- Table structure for table `coursecoreq`
--

DROP TABLE IF EXISTS `coursecoreq`;
CREATE TABLE IF NOT EXISTS `coursecoreq` (
  `CourseCoReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCoReq` varchar(30) NOT NULL,
  PRIMARY KEY (`CourseCoReqID`),
  KEY `fk_CourseCoReq_CurriculumCourse1_idx` (`CurriculumCourseID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `courseplotting`
--

DROP TABLE IF EXISTS `courseplotting`;
CREATE TABLE IF NOT EXISTS `courseplotting` (
  `CoursePlottingID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL,
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`CoursePlottingID`),
  KEY `fk_CourseRoomAssignment_CourseSchedule1_idx` (`CourseScheduleID`),
  KEY `fk_CourseRoomLabAssignment_RoomLab1_idx` (`VenueID`),
  KEY `fk_CoursePlotting_Faculty1_idx` (`EmployeeNo`),
  KEY `fk_CoursePlotting_ClassType1_idx` (`ClassTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `courseprereq`
--

DROP TABLE IF EXISTS `courseprereq`;
CREATE TABLE IF NOT EXISTS `courseprereq` (
  `CoursePreReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CoursePreReq` varchar(30) NOT NULL,
  PRIMARY KEY (`CoursePreReqID`),
  KEY `fk_CoursePreReq_CurriculumCourse1_idx` (`CurriculumCourseID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `courseschedule`
--

DROP TABLE IF EXISTS `courseschedule`;
CREATE TABLE IF NOT EXISTS `courseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CourseCode` varchar(30) NOT NULL,
  `FacultyNo` varchar(30) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Year` varchar(45) DEFAULT NULL,
  `Section` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`CourseScheduleID`),
  KEY `fk_StudentCourse_Course1_idx` (`CourseCode`),
  KEY `fk_CourseSchedule_AcademicTerm1_idx` (`AcademicTermID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `curriculum`
--

DROP TABLE IF EXISTS `curriculum`;
CREATE TABLE IF NOT EXISTS `curriculum` (
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumName` varchar(400) DEFAULT NULL,
  `CurriculumBOT` varchar(100) DEFAULT NULL,
  `Effectivity` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`CurriculumID`),
  KEY `fk_Curriculum_Program1_idx` (`ProgramID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `curriculum`
--

INSERT INTO `curriculum` (`CurriculumID`, `ProgramID`, `CurriculumName`, `CurriculumBOT`, `Effectivity`) VALUES
(0000000001, 0000000001, 'BSIT 2023 Curriculum', '2023-04', 'August 2023'),
(0000000002, 0000000002, 'BSCS 2023 Curriculum', '2023-05', 'August 2023');

-- --------------------------------------------------------

--
-- Table structure for table `curriculumcourse`
--

DROP TABLE IF EXISTS `curriculumcourse`;
CREATE TABLE IF NOT EXISTS `curriculumcourse` (
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCode` varchar(30) NOT NULL,
  `Year` int NOT NULL,
  `Term` varchar(50) NOT NULL,
  `LecUnits` int NOT NULL,
  `LabUnits` int NOT NULL,
  PRIMARY KEY (`CurriculumCourseID`),
  KEY `fk_CurriculumCourse_Curriculum1_idx` (`CurriculumID`),
  KEY `fk_CurriculumCourse_Course1_idx` (`CourseCode`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `curriculumcourse`
--

INSERT INTO `curriculumcourse` (`CurriculumCourseID`, `CurriculumID`, `CourseCode`, `Year`, `Term`, `LecUnits`, `LabUnits`) VALUES
(0000000001, 0000000001, 'CCIT101', 1, '1st', 2, 3),
(0000000002, 0000000001, 'CCIT102', 1, '2nd', 2, 3),
(0000000003, 0000000001, 'CCIT103', 2, '1st', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

DROP TABLE IF EXISTS `document`;
CREATE TABLE IF NOT EXISTS `document` (
  `DocumentID` int NOT NULL,
  `DocumentName` varchar(250) DEFAULT NULL,
  `DocumentDescription` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`DocumentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `documentrequirement`
--

DROP TABLE IF EXISTS `documentrequirement`;
CREATE TABLE IF NOT EXISTS `documentrequirement` (
  `DocumentRequirementID` int NOT NULL,
  `DocumentID` int DEFAULT NULL,
  `DocumentName` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`DocumentRequirementID`),
  KEY `fk_DocumentRequirement_Document1_idx` (`DocumentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `employee`
--

DROP TABLE IF EXISTS `employee`;
CREATE TABLE IF NOT EXISTS `employee` (
  `EmployeeNo` varchar(30) NOT NULL,
  `FirstName` varchar(350) DEFAULT NULL,
  `MiddleName` varchar(350) DEFAULT NULL,
  `LastName` varchar(350) DEFAULT NULL,
  PRIMARY KEY (`EmployeeNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `fees`
--

DROP TABLE IF EXISTS `fees`;
CREATE TABLE IF NOT EXISTS `fees` (
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`FeeID`),
  KEY `fk_Fees_Program1_idx` (`ProgramID`),
  KEY `fk_Fees_FeeType1_idx` (`FeeTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `feetype`
--

DROP TABLE IF EXISTS `feetype`;
CREATE TABLE IF NOT EXISTS `feetype` (
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `FeeType` varchar(200) NOT NULL,
  PRIMARY KEY (`FeeTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `googleaccount`
--

DROP TABLE IF EXISTS `googleaccount`;
CREATE TABLE IF NOT EXISTS `googleaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL,
  PRIMARY KEY (`EmailAddress`),
  KEY `fk_GoogleAccount_StudentInfo1_idx` (`StudentNo`),
  KEY `fk_GoogleAccount_Employee1_idx` (`EmployeeNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `grade`
--

DROP TABLE IF EXISTS `grade`;
CREATE TABLE IF NOT EXISTS `grade` (
  `GradeID` bigint NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `CourseCode` varchar(30) DEFAULT NULL,
  `Grade` varchar(45) DEFAULT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `UserIDwhoinput` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`GradeID`),
  KEY `fk_Grade_StudentInfo1_idx` (`StudentNo`),
  KEY `fk_Grade_Course1_idx` (`CourseCode`),
  KEY `fk_Grade_AcademicTerm1_idx` (`AcademicTermID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `orgactivity`
--

DROP TABLE IF EXISTS `orgactivity`;
CREATE TABLE IF NOT EXISTS `orgactivity` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ActivityName` varchar(300) DEFAULT NULL,
  `ActivityDateStart` datetime DEFAULT NULL,
  `ActivityDateEnd` datetime DEFAULT NULL,
  `ActivityType` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`OrgActivityID`),
  KEY `fk_OrgActiviy_Organization1_idx` (`OrganizationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `organization`
--

DROP TABLE IF EXISTS `organization`;
CREATE TABLE IF NOT EXISTS `organization` (
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationName` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`OrganizationID`),
  KEY `fk_Organization_Campus1_idx` (`CampusID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `orgofficer`
--

DROP TABLE IF EXISTS `orgofficer`;
CREATE TABLE IF NOT EXISTS `orgofficer` (
  `OrgOfficerID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`OrgOfficerID`),
  KEY `fk_OrgOfficer_Organization1_idx` (`OrganizationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `otherfees`
--

DROP TABLE IF EXISTS `otherfees`;
CREATE TABLE IF NOT EXISTS `otherfees` (
  `OID` int NOT NULL AUTO_INCREMENT,
  `AssessmentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OSemester` varchar(200) NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Description` varchar(100) NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL,
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpiand/Partialpaid',
  PRIMARY KEY (`OID`),
  KEY `fk_OtherFees_Student_Assessment_fees_info1_idx` (`AssessmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `payment`
--

DROP TABLE IF EXISTS `payment`;
CREATE TABLE IF NOT EXISTS `payment` (
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentNo` varchar(100) NOT NULL,
  `PaymentDate` datetime NOT NULL,
  `Amount` decimal(20,2) NOT NULL,
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`PaymentID`),
  KEY `fk_Payment_StudentInfo1_idx` (`StudentNo`),
  KEY `fk_Payment_PaymentType1_idx` (`PaymentTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `paymentitem`
--

DROP TABLE IF EXISTS `paymentitem`;
CREATE TABLE IF NOT EXISTS `paymentitem` (
  `PaymentItemID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Quantity` int NOT NULL,
  `SubTotal` decimal(30,2) NOT NULL,
  PRIMARY KEY (`PaymentItemID`),
  KEY `fk_PaymentItem_Fees1_idx` (`FeeID`),
  KEY `fk_PaymentItem_Payment1_idx` (`PaymentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `paymenttype`
--

DROP TABLE IF EXISTS `paymenttype`;
CREATE TABLE IF NOT EXISTS `paymenttype` (
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `PaymentType` varchar(100) NOT NULL,
  PRIMARY KEY (`PaymentTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `program`
--

DROP TABLE IF EXISTS `program`;
CREATE TABLE IF NOT EXISTS `program` (
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramDesc` varchar(450) NOT NULL,
  `ProgramAbbr` varchar(200) NOT NULL,
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DefaultCurriculumID` int DEFAULT NULL COMMENT 'Default Curriculum for Program',
  PRIMARY KEY (`ProgramID`),
  KEY `fk_Program_College1_idx` (`CollegeID`),
  KEY `fk_Program_ProgramLevel1_idx` (`ProgramLevelID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `program`
--

INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000001, 0000000001, 'Bachelor of Science in Information Technology', 'BSIT', 0000000001, NULL),
(0000000002, 0000000001, 'Bachelor of Science in Computer Science', 'BSCS', 0000000001, NULL),
(0000000003, 0000000001, 'Bachelor of Science in Information Science', 'BSIS', 0000000001, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `programlevel`
--

DROP TABLE IF EXISTS `programlevel`;
CREATE TABLE IF NOT EXISTS `programlevel` (
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `ProgramLevelName` varchar(250) NOT NULL,
  `ProgramLevelDesc` varchar(500) NOT NULL,
  PRIMARY KEY (`ProgramLevelID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

--
-- Dumping data for table `programlevel`
--

INSERT INTO `programlevel` (`ProgramLevelID`, `ProgramLevelName`, `ProgramLevelDesc`) VALUES
(0000000001, 'Undergraduate', '(Certificate and Bachelor Programs)'),
(0000000002, 'Graduate', '(Graduate Micro-Program, Graduate Certificate, Graduate Diploma, Master and Doctoral Programs)'),
(0000000003, 'Undergraduate Degree Transfer', '(current undergraduate students who want to transfer from one Bachelor\'s degree program to another)'),
(0000000004, 'Undergraduate Independent Student', '(Part-time studies only; Courses taken are not part of a degree or certificate.)'),
(0000000005, 'Undergraduate Visiting Student from another University', ''),
(0000000006, 'Undergraduate Microprogram', '');

-- --------------------------------------------------------

--
-- Table structure for table `scholarship`
--

DROP TABLE IF EXISTS `scholarship`;
CREATE TABLE IF NOT EXISTS `scholarship` (
  `ScholarshipID` int NOT NULL,
  `ScholarshipName` varchar(300) DEFAULT NULL,
  `Sponsor` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ScholarshipID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `scholarshipsubsidy`
--

DROP TABLE IF EXISTS `scholarshipsubsidy`;
CREATE TABLE IF NOT EXISTS `scholarshipsubsidy` (
  `ScholarshipID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ScholarshipDescription` varchar(250) NOT NULL,
  `ScholarshipSubsidy` float(15,2) NOT NULL,
  PRIMARY KEY (`ScholarshipID`),
  KEY `fk_ScholarshipSubsidy_Student_Assessment_fees_info1_idx` (`AssessmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `statement_of_account_fees`
--

DROP TABLE IF EXISTS `statement_of_account_fees`;
CREATE TABLE IF NOT EXISTS `statement_of_account_fees` (
  `ID` int NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Date_create` datetime NOT NULL,
  `Colleg_ID` int NOT NULL,
  `ProgramID` int NOT NULL,
  `Student_year` varchar(100) NOT NULL,
  PRIMARY KEY (`ID`,`Date_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAcademicHistory`
--

DROP TABLE IF EXISTS `StudentAcademicHistory`;
CREATE TABLE IF NOT EXISTS `StudentAcademicHistory` (
  `StudentAcademicHistoryID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SchoolName` varchar(500) NOT NULL,
  `FromDate` date NOT NULL,
  `ToDate` date NOT NULL,
  `Degree` varchar(45) NOT NULL,
  PRIMARY KEY (`StudentAcademicHistoryID`),
  KEY `fk_StudentAcademicHistory_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentadditionalinfo`
--

DROP TABLE IF EXISTS `studentadditionalinfo`;
CREATE TABLE IF NOT EXISTS `studentadditionalinfo` (
  `StudentAdditionalInfo` int NOT NULL,
  PRIMARY KEY (`StudentAdditionalInfo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentaddress`
--

DROP TABLE IF EXISTS `studentaddress`;
CREATE TABLE IF NOT EXISTS `studentaddress` (
  `Student_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentNo` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Student_AddressID`),
  KEY `fk_StudentAddress_StudentInfo1_idx` (`StudentNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmissionSubmission`
--

DROP TABLE IF EXISTS `StudentAdmissionSubmission`;
CREATE TABLE IF NOT EXISTS `StudentAdmissionSubmission` (
  `StudentAdmissionSubmissionID` int NOT NULL,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `DocumentRequirementID` int DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`StudentAdmissionSubmissionID`),
  KEY `fk_StudentDocumentSubmission_DocumentRequirement1_idx` (`DocumentRequirementID`),
  KEY `fk_StudentDocumentSubmission_Employee1_idx` (`EmployeeNo`),
  KEY `fk_StudentAdmissionSubmission_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentadmission_account`
--

DROP TABLE IF EXISTS `studentadmission_account`;
CREATE TABLE IF NOT EXISTS `studentadmission_account` (
  `EmailAddress` varchar(100) NOT NULL,
  `Password` varchar(500) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  PRIMARY KEY (`EmailAddress`),
  KEY `fk_StudentAdmission_Account_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Address`
--

DROP TABLE IF EXISTS `StudentAdmission_Address`;
CREATE TABLE IF NOT EXISTS `StudentAdmission_Address` (
  `StudentAdmission_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`StudentAdmission_AddressID`),
  KEY `fk_StudentAdmission_Address_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Application`
--

DROP TABLE IF EXISTS `StudentAdmission_Application`;
CREATE TABLE IF NOT EXISTS `StudentAdmission_Application` (
  `StudentAdmission_ApplicationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Remarks` varchar(250) NOT NULL,
  `DateCreated` datetime NOT NULL,
  PRIMARY KEY (`StudentAdmission_ApplicationID`),
  KEY `fk_StudentAdmission_Application_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  KEY `fk_StudentAdmission_Application_AdmissionTerm1_idx` (`AcademicTermID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentassessmentfees`
--

DROP TABLE IF EXISTS `studentassessmentfees`;
CREATE TABLE IF NOT EXISTS `studentassessmentfees` (
  `FeesID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentFessID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL COMMENT 'Paid/Unpaids',
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpaid/Partialpaid',
  PRIMARY KEY (`FeesID`),
  KEY `fk_StudentAssessmentfees_Assessment_fees_Settings1_idx` (`AssessmentFessID`),
  KEY `fk_StudentAssessmentfees_Student_Assessment_fees_info1_idx` (`AssessmentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentcourseschedule`
--

DROP TABLE IF EXISTS `studentcourseschedule`;
CREATE TABLE IF NOT EXISTS `studentcourseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  PRIMARY KEY (`CourseScheduleID`,`StudentNo`),
  KEY `fk_StudentYearCourse_StudentInfo1_idx` (`StudentNo`),
  KEY `fk_StudentPYS_CourseSchedule1_idx` (`CourseScheduleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentcurriculum`
--

DROP TABLE IF EXISTS `studentcurriculum`;
CREATE TABLE IF NOT EXISTS `studentcurriculum` (
  `StudentNo` varchar(100) NOT NULL,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isCurrent` tinyint(1) NOT NULL,
  PRIMARY KEY (`StudentNo`,`CurriculumID`),
  KEY `fk_StudentCurriculum_Curriculum1_idx` (`CurriculumID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentdocumentsubmission`
--

DROP TABLE IF EXISTS `studentdocumentsubmission`;
CREATE TABLE IF NOT EXISTS `studentdocumentsubmission` (
  `StudentDocumentSubmissionID` int NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `DocumentRequirementID` int DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`StudentDocumentSubmissionID`),
  KEY `fk_StudentRequirement_StudentInfo1_idx` (`StudentNo`),
  KEY `fk_StudentDocumentSubmission_DocumentRequirement1_idx` (`DocumentRequirementID`),
  KEY `fk_StudentDocumentSubmission_Employee1_idx` (`EmployeeNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentinfo`
--

DROP TABLE IF EXISTS `studentinfo`;
CREATE TABLE IF NOT EXISTS `studentinfo` (
  `StudentNo` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `SexAssignedAtBirth` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isTransferee` tinyint(1) NOT NULL,
  PRIMARY KEY (`StudentNo`),
  KEY `fk_StudentInfo_Citizenship1_idx` (`CitizenshipID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentInfo_Admission`
--

DROP TABLE IF EXISTS `StudentInfo_Admission`;
CREATE TABLE IF NOT EXISTS `StudentInfo_Admission` (
  `StudentAdmissionID` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `isMale` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`StudentAdmissionID`),
  KEY `fk_StudentInfo_Admission_Citizenship1_idx` (`CitizenshipID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentParentGuardian`
--

DROP TABLE IF EXISTS `StudentParentGuardian`;
CREATE TABLE IF NOT EXISTS `StudentParentGuardian` (
  `StudentParentGuardian` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SPGFirstName` varchar(350) NOT NULL,
  `SPGMiddleName` varchar(350) DEFAULT NULL,
  `SPGLastName` varchar(350) NOT NULL,
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL,
  PRIMARY KEY (`StudentParentGuardian`),
  KEY `fk_StudentParentGuardian_TypeOfParentGuardian1_idx` (`TypeOfPGid`),
  KEY `fk_StudentParentGuardian_StudentInfo_Admission1_idx` (`StudentAdmissionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `StudentProgramChoice`
--

DROP TABLE IF EXISTS `StudentProgramChoice`;
CREATE TABLE IF NOT EXISTS `StudentProgramChoice` (
  `StudentProgramChoiceID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Priority` tinyint(1) NOT NULL,
  PRIMARY KEY (`StudentProgramChoiceID`),
  KEY `fk_StudentProgramChoice_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  KEY `fk_StudentProgramChoice_Program1_idx` (`ProgramID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `studentscholarship`
--

DROP TABLE IF EXISTS `studentscholarship`;
CREATE TABLE IF NOT EXISTS `studentscholarship` (
  `StudentScholarshipID` int NOT NULL,
  `ScholarshipID` int DEFAULT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `AcademicYear` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`StudentScholarshipID`),
  KEY `fk_StudentScholarship_Scholarship1_idx` (`ScholarshipID`),
  KEY `fk_StudentScholarship_StudentInfo1_idx` (`StudentNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `student_assessment`
--

DROP TABLE IF EXISTS `student_assessment`;
CREATE TABLE IF NOT EXISTS `student_assessment` (
  `SAID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentID` varchar(100) NOT NULL,
  `CollegeID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Semester` varchar(100) NOT NULL,
  `YearLevel` varchar(100) NOT NULL,
  `CourseSection` varchar(100) NOT NULL,
  `CourseCode` varchar(100) NOT NULL,
  PRIMARY KEY (`SAID`),
  KEY `fk_Student_Assessment_fees_StudentInfo1_idx` (`StudentID`),
  KEY `fk_Student_Assessment_fees_info_College1_idx` (`CollegeID`),
  KEY `fk_Student_Assessment_fees_info_Program1_idx` (`ProgramID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `transaction`
--

DROP TABLE IF EXISTS `transaction`;
CREATE TABLE IF NOT EXISTS `transaction` (
  `TransactionID` int NOT NULL,
  `StudentNo` varchar(45) DEFAULT NULL,
  `TransactionDesc` varchar(45) DEFAULT NULL,
  `Office` varchar(45) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `TransactionRequirements` varchar(45) DEFAULT NULL,
  `TransactionPayment` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`TransactionID`),
  KEY `fk_Transaction_StudentInfo1_idx` (`StudentNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `typeofparentguardian`
--

DROP TABLE IF EXISTS `typeofparentguardian`;
CREATE TABLE IF NOT EXISTS `typeofparentguardian` (
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `TypeOfParentGuardian` varchar(250) NOT NULL,
  PRIMARY KEY (`TypeOfPGid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `venue`
--

DROP TABLE IF EXISTS `venue`;
CREATE TABLE IF NOT EXISTS `venue` (
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `VenueDesc` varchar(300) NOT NULL,
  PRIMARY KEY (`VenueID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `venueavailability`
--

DROP TABLE IF EXISTS `venueavailability`;
CREATE TABLE IF NOT EXISTS `venueavailability` (
  `VenueAvailabilityID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL,
  PRIMARY KEY (`VenueAvailabilityID`),
  KEY `fk_RoomLabAvailability_RoomLab1_idx` (`VenueID`),
  KEY `fk_RoomLabAvailability_AcademicTerm1_idx` (`AcademicTermID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- --------------------------------------------------------

--
-- Table structure for table `version`
--

DROP TABLE IF EXISTS `version`;
CREATE TABLE IF NOT EXISTS `version` (
  `VersionID` int NOT NULL,
  `DateTime` datetime DEFAULT NULL,
  `VersionDesc` longtext NOT NULL,
  `ResponsiblePerson` varchar(300) NOT NULL,
  PRIMARY KEY (`VersionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accountlogs`
--
ALTER TABLE `accountlogs`
  ADD CONSTRAINT `fk_AccountLogs_GoogleAccount1` FOREIGN KEY (`EmailAddress`) REFERENCES `googleaccount` (`EmailAddress`);

--
-- Constraints for table `activityvenue`
--
ALTER TABLE `activityvenue`
  ADD CONSTRAINT `fk_ActivityVenue_OrgActiviy1` FOREIGN KEY (`OrgActivityID`) REFERENCES `orgactivity` (`OrgActivityID`),
  ADD CONSTRAINT `fk_ActivityVenue_Venue1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`);

--
-- Constraints for table `admissionaccount`
--
ALTER TABLE `admissionaccount`
  ADD CONSTRAINT `fk_AdmissionAccount_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `clearance`
--
ALTER TABLE `clearance`
  ADD CONSTRAINT `fk_Clearance_Student_Assessment1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `college`
--
ALTER TABLE `college`
  ADD CONSTRAINT `fk_College_Campus` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`);

--
-- Constraints for table `course`
--
ALTER TABLE `course`
  ADD CONSTRAINT `fk_Course_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`);

--
-- Constraints for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  ADD CONSTRAINT `fk_CourseCoReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`);

--
-- Constraints for table `courseplotting`
--
ALTER TABLE `courseplotting`
  ADD CONSTRAINT `fk_CoursePlotting_ClassType1` FOREIGN KEY (`ClassTypeID`) REFERENCES `classtype` (`ClassTypeID`),
  ADD CONSTRAINT `fk_CoursePlotting_Faculty1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`),
  ADD CONSTRAINT `fk_CourseRoomAssignment_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`),
  ADD CONSTRAINT `fk_CourseRoomLabAssignment_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`);

--
-- Constraints for table `courseprereq`
--
ALTER TABLE `courseprereq`
  ADD CONSTRAINT `fk_CoursePreReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`);

--
-- Constraints for table `courseschedule`
--
ALTER TABLE `courseschedule`
  ADD CONSTRAINT `fk_CourseSchedule_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`),
  ADD CONSTRAINT `fk_StudentCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`);

--
-- Constraints for table `curriculum`
--
ALTER TABLE `curriculum`
  ADD CONSTRAINT `fk_Curriculum_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`);

--
-- Constraints for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  ADD CONSTRAINT `fk_CurriculumCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`),
  ADD CONSTRAINT `fk_CurriculumCourse_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`);

--
-- Constraints for table `documentrequirement`
--
ALTER TABLE `documentrequirement`
  ADD CONSTRAINT `fk_DocumentRequirement_Document1` FOREIGN KEY (`DocumentID`) REFERENCES `document` (`DocumentID`);

--
-- Constraints for table `fees`
--
ALTER TABLE `fees`
  ADD CONSTRAINT `fk_Fees_FeeType1` FOREIGN KEY (`FeeTypeID`) REFERENCES `feetype` (`FeeTypeID`),
  ADD CONSTRAINT `fk_Fees_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`);

--
-- Constraints for table `googleaccount`
--
ALTER TABLE `googleaccount`
  ADD CONSTRAINT `fk_GoogleAccount_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`),
  ADD CONSTRAINT `fk_GoogleAccount_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `grade`
--
ALTER TABLE `grade`
  ADD CONSTRAINT `fk_Grade_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`),
  ADD CONSTRAINT `fk_Grade_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`),
  ADD CONSTRAINT `fk_Grade_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `orgactivity`
--
ALTER TABLE `orgactivity`
  ADD CONSTRAINT `fk_OrgActiviy_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`);

--
-- Constraints for table `organization`
--
ALTER TABLE `organization`
  ADD CONSTRAINT `fk_Organization_Campus1` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`);

--
-- Constraints for table `orgofficer`
--
ALTER TABLE `orgofficer`
  ADD CONSTRAINT `fk_OrgOfficer_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`);

--
-- Constraints for table `otherfees`
--
ALTER TABLE `otherfees`
  ADD CONSTRAINT `fk_OtherFees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `payment`
--
ALTER TABLE `payment`
  ADD CONSTRAINT `fk_Payment_PaymentType1` FOREIGN KEY (`PaymentTypeID`) REFERENCES `paymenttype` (`PaymentTypeID`),
  ADD CONSTRAINT `fk_Payment_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `paymentitem`
--
ALTER TABLE `paymentitem`
  ADD CONSTRAINT `fk_PaymentItem_Fees1` FOREIGN KEY (`FeeID`) REFERENCES `fees` (`FeeID`),
  ADD CONSTRAINT `fk_PaymentItem_Payment1` FOREIGN KEY (`PaymentID`) REFERENCES `payment` (`PaymentID`);

--
-- Constraints for table `program`
--
ALTER TABLE `program`
  ADD CONSTRAINT `fk_Program_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`),
  ADD CONSTRAINT `fk_Program_ProgramLevel1` FOREIGN KEY (`ProgramLevelID`) REFERENCES `programlevel` (`ProgramLevelID`);

--
-- Constraints for table `scholarshipsubsidy`
--
ALTER TABLE `scholarshipsubsidy`
  ADD CONSTRAINT `fk_ScholarshipSubsidy_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  ADD CONSTRAINT `fk_StudentAcademicHistory_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `studentaddress`
--
ALTER TABLE `studentaddress`
  ADD CONSTRAINT `fk_StudentAddress_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `StudentAdmissionSubmission`
--
ALTER TABLE `StudentAdmissionSubmission`
  ADD CONSTRAINT `fk_StudentAdmissionSubmission_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`),
  ADD CONSTRAINT `fk_StudentDocumentSubmission_DocumentRequirement10` FOREIGN KEY (`DocumentRequirementID`) REFERENCES `documentrequirement` (`DocumentRequirementID`),
  ADD CONSTRAINT `fk_StudentDocumentSubmission_Employee10` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`);

--
-- Constraints for table `studentadmission_account`
--
ALTER TABLE `studentadmission_account`
  ADD CONSTRAINT `fk_StudentAdmission_Account_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  ADD CONSTRAINT `fk_StudentAdmission_Address_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  ADD CONSTRAINT `fk_StudentAdmission_Application_AdmissionTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`),
  ADD CONSTRAINT `fk_StudentAdmission_Application_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `studentassessmentfees`
--
ALTER TABLE `studentassessmentfees`
  ADD CONSTRAINT `fk_StudentAssessmentfees_Assessment_fees_Settings1` FOREIGN KEY (`AssessmentFessID`) REFERENCES `assessmentfeessettings` (`AssessmentID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_StudentAssessmentfees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `studentcourseschedule`
--
ALTER TABLE `studentcourseschedule`
  ADD CONSTRAINT `fk_StudentPYS_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`),
  ADD CONSTRAINT `fk_StudentYearCourse_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `studentcurriculum`
--
ALTER TABLE `studentcurriculum`
  ADD CONSTRAINT `fk_StudentCurriculum_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`),
  ADD CONSTRAINT `fk_StudentCurriculum_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `studentdocumentsubmission`
--
ALTER TABLE `studentdocumentsubmission`
  ADD CONSTRAINT `fk_StudentDocumentSubmission_DocumentRequirement1` FOREIGN KEY (`DocumentRequirementID`) REFERENCES `documentrequirement` (`DocumentRequirementID`),
  ADD CONSTRAINT `fk_StudentDocumentSubmission_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`),
  ADD CONSTRAINT `fk_StudentRequirement_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `studentinfo`
--
ALTER TABLE `studentinfo`
  ADD CONSTRAINT `fk_StudentInfo_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`);

--
-- Constraints for table `StudentInfo_Admission`
--
ALTER TABLE `StudentInfo_Admission`
  ADD CONSTRAINT `fk_StudentInfo_Admission_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`);

--
-- Constraints for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  ADD CONSTRAINT `fk_StudentParentGuardian_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`),
  ADD CONSTRAINT `fk_StudentParentGuardian_TypeOfParentGuardian1` FOREIGN KEY (`TypeOfPGid`) REFERENCES `typeofparentguardian` (`TypeOfPGid`);

--
-- Constraints for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  ADD CONSTRAINT `fk_StudentProgramChoice_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`),
  ADD CONSTRAINT `fk_StudentProgramChoice_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`);

--
-- Constraints for table `studentscholarship`
--
ALTER TABLE `studentscholarship`
  ADD CONSTRAINT `fk_StudentScholarship_Scholarship1` FOREIGN KEY (`ScholarshipID`) REFERENCES `scholarship` (`ScholarshipID`),
  ADD CONSTRAINT `fk_StudentScholarship_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `student_assessment`
--
ALTER TABLE `student_assessment`
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `transaction`
--
ALTER TABLE `transaction`
  ADD CONSTRAINT `fk_Transaction_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`);

--
-- Constraints for table `venueavailability`
--
ALTER TABLE `venueavailability`
  ADD CONSTRAINT `fk_RoomLabAvailability_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`),
  ADD CONSTRAINT `fk_RoomLabAvailability_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
